/* The processor calls these handlers when an interrupt is triggered */
#include "maindefs.h"
#include "msg_queues.h"
#include <timers.h>
#include "timers.h"
#include "pwm.h"

unsigned char overflow_counter;

void timers_init() {
    /*--------------------Timer Delay Formulas-------------------- */
    /* InitTMR0 = 256 - ( Delay * Frequency ) / ( 4* Prescaler)    */
    /* Delay = (256 - InitTMR0 * Prescaler) / (Frequency / 4)      */
    /* ----------------------------------------------------------- */

    // Sleep timer
    OpenTimer0(TIMER_INT_ON & T0_16BIT & T0_SOURCE_INT & T0_PS_1_256);
    T0CONbits.TMR0ON = 0;   // Timer 0 initially off

#ifdef _BASE_STATION
    OpenTimer1(TIMER_INT_ON & T1_16BIT_RW &
                T1_SOURCE_FOSC_4 & T1_PS_1_1 &
                T1_OSC1EN_OFF & T1_SYNC_EXT_OFF,
                TIMER_GATE_OFF & TIMER_GATE_INT_OFF);
    T1CONbits.TMR1ON = 0;   // Timer 1 initially off
    overflow_counter = 0;
#endif
#ifdef _REMOTE
    // Data polling timer
    OpenTimer1(TIMER_INT_ON & T1_16BIT_RW &
                T1_SOURCE_FOSC_4 & T1_PS_1_1 &
                T1_OSC1EN_OFF & T1_SYNC_EXT_OFF,
                TIMER_GATE_OFF & TIMER_GATE_INT_OFF);
    T1CONbits.TMR1ON = 0;   // Timer 1 initially off
    overflow_counter = 0;

    // Open timer 2 for ECCP1 (PWM)
    OpenTimer2(TIMER_INT_OFF & T2_PS_1_4 & T2_POST_1_1);

    // Open timer 3 for PWM IR signaling
    OpenTimer3(TIMER_INT_ON & T3_16BIT_RW & T3_SOURCE_FOSC_4 & 
            T3_OSC1EN_OFF & T3_PS_1_1 & T3_SYNC_EXT_OFF, TIMER_GATE_OFF);
    T3CONbits.TMR3ON = 0;   // Timer 3 initially off
#endif
}

// Interrupt handler for timer 0
void timer0_interrupt_handler() {
    timer0_disable();   // Run once!
    MQ_sendmsg_ToMainFromLow(0, MSGTYPE_TIMER0, (void *) 0);
}

void timer0_enable() {
    WriteTimer0(0);
    T0CONbits.TMR0ON = 1;
}

void timer0_disable() {
    T0CONbits.TMR0ON = 0;
}

// Interrupt handler for timer 1
void timer1_interrupt_handler() {
#ifdef _REMOTE
    overflow_counter++;
    if (overflow_counter % 3 == 0) {
        MQ_sendmsg_ToMainFromLow(0, MSGTYPE_TIMER1, (void *) 0);
    }
#endif
#ifdef _BASE_STATION
    MQ_sendmsg_ToMainFromLow(0, MSGTYPE_TIMER1, (void *) 0);
    timer1_disable();
#endif
}

void timer1_enable() {
    WriteTimer1(0);
    T1CONbits.TMR1ON = 1;
}

void timer1_disable() {
    T1CONbits.TMR1ON = 0;
}

// Interrupt handler for timer 2
void timer2_interrupt_handler() {
    MQ_sendmsg_ToMainFromLow(0, MSGTYPE_TIMER2, (void *) 0);
}

void timer2_enable() {
    WriteTimer2(0);
    T2CONbits.TMR2ON = 1;
}

void timer2_disable() {
    T2CONbits.TMR2ON = 0;
}

void timer3_interrupt_handler() {
#ifdef _REMOTE
    if (!PWM_IR_STATE) {
        // Turn on PWM
        pwm_IR_start();
        PWM_IR_STATE = 1;
        WriteTimer3(0xEA00);    // Send 38kHz pulses for 600us
    } else {
        // Turn off PWM
        pwm_IR_stop();
        PWM_IR_STATE = 0;
//        WriteTimer3(0xEA00);    // Send low for 0.6ms
//        WriteTimer3(0xD800);    // Send low for 1ms
//        WriteTimer3(0xB000);    // Send low for 2ms
        WriteTimer3(0x1000);    // Send low for 6ms
    }
#endif
}

void timer3_enable() {
    // Enable timer and start PWM
    T3CONbits.TMR3ON = 1;
    pwm_IR_start();
    PWM_IR_STATE = 1;
}

void timer3_disable() {
    // Disable timer and stop PWM
    T3CONbits.TMR3ON = 0;
    pwm_IR_stop();
    PWM_IR_STATE = 0;
}
